<?php
require_once __DIR__ . '/config/config.php';

$pageTitle = 'Support Center - Customer Feedback & Complaint Management';
require_once __DIR__ . '/includes/header.php';
?>

<!-- Hero Section -->
<div class="gradient-bg rounded-3xl p-8 md:p-12 mb-12 text-white relative overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute top-0 right-0 w-96 h-96 bg-white rounded-full -translate-y-1/2 translate-x-1/2"></div>
        <div class="absolute bottom-0 left-0 w-64 h-64 bg-white rounded-full translate-y-1/2 -translate-x-1/2"></div>
    </div>
    <div class="relative z-10 max-w-3xl">
        <h1 class="text-3xl md:text-5xl font-bold mb-4">Customer Support Center</h1>
        <p class="text-lg md:text-xl opacity-90 mb-8">
            We're here to help! Submit your feedback or complaints by scanning the QR code on your invoice. We'll ensure they reach the right department for quick resolution.
        </p>
        <div class="flex flex-wrap gap-4">
            <?php if (isCustomerLoggedIn()): ?>
                <a href="<?= BASE_URL ?>/customer/dashboard.php" class="bg-white text-primary px-6 py-3 rounded-lg font-semibold hover:bg-gray-100 transition inline-flex items-center">
                    <i class="fas fa-tachometer-alt mr-2"></i>Go to Dashboard
                </a>
            <?php else: ?>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg p-4 inline-flex items-center gap-4">
                    <i class="fas fa-qrcode text-4xl"></i>
                    <div>
                        <p class="font-semibold">Scan QR Code</p>
                        <p class="text-sm opacity-90">On your invoice to submit a complaint</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Features Section -->
<div class="mb-12">
    <h2 class="text-2xl font-bold text-gray-800 text-center mb-8">How It Works</h2>
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-xl p-6 shadow-lg hover:shadow-xl transition text-center">
            <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-qrcode text-blue-600 text-2xl"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 mb-2">1. Scan QR Code</h3>
            <p class="text-gray-600">Scan the QR code printed on your invoice to access the complaint form.</p>
        </div>
        <div class="bg-white rounded-xl p-6 shadow-lg hover:shadow-xl transition text-center">
            <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fab fa-whatsapp text-green-600 text-2xl"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 mb-2">2. Verify WhatsApp</h3>
            <p class="text-gray-600">Enter your WhatsApp number and verify with OTP sent to your phone.</p>
        </div>
        <div class="bg-white rounded-xl p-6 shadow-lg hover:shadow-xl transition text-center">
            <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-list-ul text-yellow-600 text-2xl"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 mb-2">3. Select Issue</h3>
            <p class="text-gray-600">Choose from our detailed list of issues that best describes your problem.</p>
        </div>
        <div class="bg-white rounded-xl p-6 shadow-lg hover:shadow-xl transition text-center">
            <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-check-circle text-purple-600 text-2xl"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 mb-2">4. Track & Resolve</h3>
            <p class="text-gray-600">Monitor your complaint status and communicate with our team.</p>
        </div>
    </div>
</div>

<!-- Stats Section -->
<div class="bg-white rounded-2xl shadow-lg p-8 mb-12">
    <div class="grid grid-cols-2 md:grid-cols-4 gap-6 text-center">
        <div>
            <div class="text-3xl md:text-4xl font-bold text-primary mb-2">98%</div>
            <div class="text-gray-600">Resolution Rate</div>
        </div>
        <div>
            <div class="text-3xl md:text-4xl font-bold text-primary mb-2">24h</div>
            <div class="text-gray-600">Avg. Response Time</div>
        </div>
        <div>
            <div class="text-3xl md:text-4xl font-bold text-primary mb-2">5K+</div>
            <div class="text-gray-600">Happy Customers</div>
        </div>
        <div>
            <div class="text-3xl md:text-4xl font-bold text-primary mb-2">4.9</div>
            <div class="text-gray-600">Customer Rating</div>
        </div>
    </div>
</div>

<!-- Departments Section -->
<div class="mb-12">
    <h2 class="text-2xl font-bold text-gray-800 text-center mb-8">Our Departments</h2>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4">
        <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl p-5 text-white text-center hover:scale-105 transition">
            <i class="fas fa-headset text-3xl mb-3"></i>
            <h3 class="font-semibold">Customer Service</h3>
        </div>
        <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl p-5 text-white text-center hover:scale-105 transition">
            <i class="fas fa-tools text-3xl mb-3"></i>
            <h3 class="font-semibold">Technical Support</h3>
        </div>
        <div class="bg-gradient-to-br from-yellow-500 to-yellow-600 rounded-xl p-5 text-white text-center hover:scale-105 transition">
            <i class="fas fa-file-invoice-dollar text-3xl mb-3"></i>
            <h3 class="font-semibold">Billing</h3>
        </div>
        <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl p-5 text-white text-center hover:scale-105 transition">
            <i class="fas fa-shipping-fast text-3xl mb-3"></i>
            <h3 class="font-semibold">Shipping</h3>
        </div>
        <div class="bg-gradient-to-br from-red-500 to-red-600 rounded-xl p-5 text-white text-center hover:scale-105 transition">
            <i class="fas fa-award text-3xl mb-3"></i>
            <h3 class="font-semibold">Quality Assurance</h3>
        </div>
    </div>
</div>

<!-- CTA Section -->
<div class="bg-gray-100 rounded-2xl p-8 text-center">
    <h2 class="text-2xl font-bold text-gray-800 mb-4">Need Help With an Order?</h2>
    <p class="text-gray-600 mb-6 max-w-2xl mx-auto">
        Simply scan the QR code on your invoice to submit a complaint. Your WhatsApp number will be verified for secure access.
    </p>
    <div class="flex flex-wrap justify-center gap-4">
        <a href="<?= BASE_URL ?>/faq.php" class="gradient-bg text-white px-8 py-3 rounded-lg font-semibold hover:opacity-90 transition">
            <i class="fas fa-question-circle mr-2"></i>View FAQ
        </a>
        <a href="<?= BASE_URL ?>/contact.php" class="bg-white text-gray-800 px-8 py-3 rounded-lg font-semibold hover:bg-gray-50 transition border border-gray-300">
            <i class="fas fa-envelope mr-2"></i>Contact Us
        </a>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
