<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Complaint Management System' ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#4F46E5',
                        secondary: '#7C3AED'
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #4F46E5 0%, #7C3AED 100%);
        }
        /* Fix dropdown hover issue - use click instead */
        .dropdown-menu {
            display: none;
        }
        .dropdown.active .dropdown-menu {
            display: block;
        }
        /* Mobile menu toggle */
        .mobile-menu {
            display: none;
        }
        .mobile-menu.active {
            display: block;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Navigation -->
    <nav class="gradient-bg shadow-lg sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <a href="<?= BASE_URL ?>/" class="flex items-center space-x-2">
                        <i class="fas fa-headset text-white text-2xl"></i>
                        <span class="text-white font-bold text-xl hidden sm:block">Support Center</span>
                    </a>
                </div>
                
                <div class="flex items-center space-x-4">
                    <?php if (isLoggedIn()): ?>
                        <div class="hidden md:flex items-center space-x-4">
                            <?php if (isAdmin()): ?>
                                <a href="<?= BASE_URL ?>/admin/dashboard.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-tachometer-alt mr-1"></i> Dashboard
                                </a>
                                <a href="<?= BASE_URL ?>/admin/complaints.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-list mr-1"></i> Complaints
                                </a>
                                <a href="<?= BASE_URL ?>/admin/branches.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-store mr-1"></i> Branches
                                </a>
                                <a href="<?= BASE_URL ?>/admin/users.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-users mr-1"></i> Users
                                </a>
                            <?php elseif (isBranchManager()): ?>
                                <a href="<?= BASE_URL ?>/manager/dashboard.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-tachometer-alt mr-1"></i> Dashboard
                                </a>
                                <a href="<?= BASE_URL ?>/manager/complaints.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-list mr-1"></i> Complaints
                                </a>
                            <?php elseif (isStaff()): ?>
                                <a href="<?= BASE_URL ?>/staff/dashboard.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-tachometer-alt mr-1"></i> Dashboard
                                </a>
                                <a href="<?= BASE_URL ?>/staff/complaints.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-list mr-1"></i> Assigned
                                </a>
                            <?php else: ?>
                                <!-- Customer navigation -->
                                <a href="<?= BASE_URL ?>/customer/dashboard.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-home mr-1"></i> My Dashboard
                                </a>
                                <a href="<?= BASE_URL ?>/customer/complaints.php" class="text-white hover:text-gray-200 transition">
                                    <i class="fas fa-ticket-alt mr-1"></i> My Complaints
                                </a>
                            <?php endif; ?>
                        </div>
                        
                        <!-- User dropdown - click based for mobile compatibility -->
                        <div class="relative dropdown" id="userDropdown">
                            <button onclick="toggleDropdown('userDropdown')" class="flex items-center space-x-2 text-white hover:text-gray-200 transition">
                                <div class="w-8 h-8 bg-white/20 rounded-full flex items-center justify-center">
                                    <?php if (isCustomer()): ?>
                                    <i class="fab fa-whatsapp"></i>
                                    <?php else: ?>
                                    <i class="fas fa-user"></i>
                                    <?php endif; ?>
                                </div>
                                <span class="hidden sm:block text-sm">
                                    <?php if (isCustomer()): ?>
                                        <?= sanitize($_SESSION['whatsapp_number'] ?? 'Customer') ?>
                                    <?php else: ?>
                                        <?= sanitize($_SESSION['user_name'] ?? 'User') ?>
                                    <?php endif; ?>
                                </span>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </button>
                            <div class="dropdown-menu absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 z-50">
                                <?php if (!isCustomer()): ?>
                                <a href="<?= BASE_URL ?>/profile.php" class="block px-4 py-2 text-gray-700 hover:bg-gray-100">
                                    <i class="fas fa-user-cog mr-2"></i> Profile
                                </a>
                                <hr class="my-2">
                                <?php endif; ?>
                                <a href="<?= BASE_URL ?>/auth/logout.php" class="block px-4 py-2 text-red-600 hover:bg-gray-100">
                                    <i class="fas fa-sign-out-alt mr-2"></i> Logout
                                </a>
                            </div>
                        </div>
                        
                        <!-- Mobile menu toggle button -->
                        <button onclick="toggleMobileMenu()" class="md:hidden text-white p-2">
                            <i class="fas fa-bars text-xl" id="mobileMenuIcon"></i>
                        </button>
                    <?php else: ?>
                        <!-- Show nothing for non-logged in users - they access via QR code -->
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Mobile menu - hidden by default, toggled by JS -->
        <?php if (isLoggedIn()): ?>
        <div class="mobile-menu md:hidden border-t border-white/20" id="mobileMenu">
            <div class="px-4 py-3 space-y-3">
                <?php if (isAdmin()): ?>
                    <a href="<?= BASE_URL ?>/admin/dashboard.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-tachometer-alt mr-2"></i>Dashboard
                    </a>
                    <a href="<?= BASE_URL ?>/admin/complaints.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-list mr-2"></i>Complaints
                    </a>
                    <a href="<?= BASE_URL ?>/admin/branches.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-store mr-2"></i>Branches
                    </a>
                    <a href="<?= BASE_URL ?>/admin/users.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-users mr-2"></i>Users
                    </a>
                <?php elseif (isBranchManager()): ?>
                    <a href="<?= BASE_URL ?>/manager/dashboard.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-tachometer-alt mr-2"></i>Dashboard
                    </a>
                    <a href="<?= BASE_URL ?>/manager/complaints.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-list mr-2"></i>Branch Complaints
                    </a>
                <?php elseif (isStaff()): ?>
                    <a href="<?= BASE_URL ?>/staff/dashboard.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-tachometer-alt mr-2"></i>Dashboard
                    </a>
                    <a href="<?= BASE_URL ?>/staff/complaints.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-list mr-2"></i>Assigned
                    </a>
                <?php else: ?>
                    <a href="<?= BASE_URL ?>/customer/dashboard.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-home mr-2"></i>My Dashboard
                    </a>
                    <a href="<?= BASE_URL ?>/customer/complaints.php" class="block text-white hover:text-gray-200 py-2">
                        <i class="fas fa-ticket-alt mr-2"></i>My Complaints
                    </a>
                <?php endif; ?>
                <hr class="border-white/20">
                <?php if (!isCustomer()): ?>
                <a href="<?= BASE_URL ?>/profile.php" class="block text-white hover:text-gray-200 py-2">
                    <i class="fas fa-user-cog mr-2"></i>Profile
                </a>
                <?php endif; ?>
                <a href="<?= BASE_URL ?>/auth/logout.php" class="block text-red-300 hover:text-red-100 py-2">
                    <i class="fas fa-sign-out-alt mr-2"></i>Logout
                </a>
            </div>
        </div>
        <?php endif; ?>
    </nav>
    
    <!-- JavaScript for dropdowns and mobile menu -->
    <script>
        function toggleDropdown(id) {
            const dropdown = document.getElementById(id);
            const allDropdowns = document.querySelectorAll('.dropdown');
            
            // Close all other dropdowns
            allDropdowns.forEach(d => {
                if (d.id !== id) d.classList.remove('active');
            });
            
            // Toggle this dropdown
            dropdown.classList.toggle('active');
        }
        
        function toggleMobileMenu() {
            const menu = document.getElementById('mobileMenu');
            const icon = document.getElementById('mobileMenuIcon');
            
            menu.classList.toggle('active');
            
            // Toggle icon
            if (menu.classList.contains('active')) {
                icon.classList.remove('fa-bars');
                icon.classList.add('fa-times');
            } else {
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            }
        }
        
        // Close dropdowns when clicking outside
        document.addEventListener('click', function(e) {
            const dropdowns = document.querySelectorAll('.dropdown');
            dropdowns.forEach(dropdown => {
                if (!dropdown.contains(e.target)) {
                    dropdown.classList.remove('active');
                }
            });
        });
    </script>

    <!-- Flash Messages -->
    <?php $flash = getFlashMessage(); ?>
    <?php if ($flash): ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-4">
        <div class="<?= $flash['type'] === 'success' ? 'bg-green-100 border-green-500 text-green-700' : 'bg-red-100 border-red-500 text-red-700' ?> border-l-4 p-4 rounded-r-lg" role="alert">
            <p><?= sanitize($flash['message']) ?></p>
        </div>
    </div>
    <?php endif; ?>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
