<?php
require_once __DIR__ . '/config/config.php';

$pageTitle = 'FAQ - Support Center';
require_once __DIR__ . '/includes/header.php';

$faqs = [
    [
        'question' => 'How do I submit a complaint?',
        'answer' => 'To submit a complaint, you need to use the unique link provided with your order confirmation. This link contains your order number and will take you directly to the complaint submission form. You must be logged in to submit a complaint.'
    ],
    [
        'question' => 'Why can\'t I enter my order number manually?',
        'answer' => 'For security and verification purposes, order numbers must be provided through the official order link. This ensures that only legitimate order holders can submit complaints for their orders.'
    ],
    [
        'question' => 'How long does it take to resolve a complaint?',
        'answer' => 'Most complaints are resolved within 24-48 hours. However, complex issues may take longer. You can track the status of your complaint through your dashboard at any time.'
    ],
    [
        'question' => 'Who can close my complaint?',
        'answer' => 'Only you (the complaint owner) or a system administrator can close a complaint. This ensures that complaints are only closed when you are satisfied with the resolution.'
    ],
    [
        'question' => 'How do I track my complaint status?',
        'answer' => 'After logging in, go to "My Complaints" in your dashboard. You\'ll see all your submitted complaints with their current status. Click on any complaint to view details and conversation history.'
    ],
    [
        'question' => 'Can I reopen a closed complaint?',
        'answer' => 'Yes, if you\'re not satisfied with the resolution, you can reopen a closed complaint from the complaint detail page. Simply click the "Reopen Complaint" button.'
    ],
    [
        'question' => 'How do I attach files to my complaint?',
        'answer' => 'When submitting a complaint, you can attach files (images, PDFs, documents) using the attachment section. Supported formats include PNG, JPG, PDF, DOC, and DOCX up to 5MB.'
    ],
    [
        'question' => 'What happens after I submit a complaint?',
        'answer' => 'Your complaint is automatically routed to the relevant department based on the category you select. A support agent will review your complaint and respond as soon as possible.'
    ]
];
?>

<div class="max-w-3xl mx-auto">
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-gray-800">Frequently Asked Questions</h1>
        <p class="text-gray-500 mt-2">Find answers to common questions about our complaint management system</p>
    </div>

    <div class="space-y-4">
        <?php foreach ($faqs as $index => $faq): ?>
        <div class="bg-white rounded-xl shadow-lg overflow-hidden">
            <button class="w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition focus:outline-none" 
                    onclick="toggleFaq(<?= $index ?>)">
                <span class="font-semibold text-gray-800"><?= sanitize($faq['question']) ?></span>
                <i class="fas fa-chevron-down text-gray-400 transition-transform" id="icon-<?= $index ?>"></i>
            </button>
            <div class="hidden px-6 pb-4" id="answer-<?= $index ?>">
                <p class="text-gray-600"><?= sanitize($faq['answer']) ?></p>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <div class="mt-8 bg-gradient-to-r from-primary to-secondary rounded-xl p-6 text-white text-center">
        <h3 class="text-xl font-semibold mb-2">Still have questions?</h3>
        <p class="opacity-90 mb-4">Our support team is ready to help you</p>
        <a href="<?= BASE_URL ?>/contact.php" class="inline-block bg-white text-primary px-6 py-2 rounded-lg font-medium hover:bg-gray-100 transition">
            <i class="fas fa-envelope mr-2"></i>Contact Us
        </a>
    </div>
</div>

<script>
function toggleFaq(index) {
    const answer = document.getElementById('answer-' + index);
    const icon = document.getElementById('icon-' + index);
    
    if (answer.classList.contains('hidden')) {
        answer.classList.remove('hidden');
        icon.style.transform = 'rotate(180deg)';
    } else {
        answer.classList.add('hidden');
        icon.style.transform = 'rotate(0deg)';
    }
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
