<?php
require_once __DIR__ . '/config/config.php';

$pageTitle = 'Contact Us - Support Center';
require_once __DIR__ . '/includes/header.php';
?>

<div class="max-w-4xl mx-auto">
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-gray-800">Contact Us</h1>
        <p class="text-gray-500 mt-2">We're here to help. Reach out to us through any of these channels.</p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <div class="bg-white rounded-xl shadow-lg p-6 text-center">
            <div class="w-16 h-16 gradient-bg rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-envelope text-white text-2xl"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 mb-2">Email</h3>
            <p class="text-gray-600">support@company.com</p>
            <p class="text-sm text-gray-500 mt-2">We respond within 24 hours</p>
        </div>

        <div class="bg-white rounded-xl shadow-lg p-6 text-center">
            <div class="w-16 h-16 gradient-bg rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-phone text-white text-2xl"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 mb-2">Phone</h3>
            <p class="text-gray-600">+1 (555) 123-4567</p>
            <p class="text-sm text-gray-500 mt-2">Mon-Fri: 9AM - 6PM</p>
        </div>

        <div class="bg-white rounded-xl shadow-lg p-6 text-center">
            <div class="w-16 h-16 gradient-bg rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-map-marker-alt text-white text-2xl"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 mb-2">Address</h3>
            <p class="text-gray-600">123 Business Street</p>
            <p class="text-sm text-gray-500 mt-2">New York, NY 10001</p>
        </div>
    </div>

    <div class="bg-white rounded-xl shadow-lg p-8">
        <h2 class="text-xl font-semibold text-gray-800 mb-6">Send us a Message</h2>
        <form class="space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Your Name</label>
                    <input type="text" id="name" name="name" required
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                        placeholder="John Doe">
                </div>
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                    <input type="email" id="email" name="email" required
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                        placeholder="you@example.com">
                </div>
            </div>

            <div>
                <label for="subject" class="block text-sm font-medium text-gray-700 mb-2">Subject</label>
                <input type="text" id="subject" name="subject" required
                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="How can we help?">
            </div>

            <div>
                <label for="message" class="block text-sm font-medium text-gray-700 mb-2">Message</label>
                <textarea id="message" name="message" rows="5" required
                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent resize-none"
                    placeholder="Tell us more about your inquiry..."></textarea>
            </div>

            <button type="submit" class="gradient-bg text-white px-8 py-3 rounded-lg font-semibold hover:opacity-90 transition">
                <i class="fas fa-paper-plane mr-2"></i>Send Message
            </button>
        </form>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
