<?php
require_once __DIR__ . '/../config/config.php';

if (isLoggedIn()) {
    $role = getCurrentUserRole();
    if ($role === 'admin') redirect('/admin/dashboard.php');
    elseif ($role === 'staff') redirect('/staff/dashboard.php');
    else redirect('/customer/dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitize($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($email) || empty($password)) {
        $error = 'Please fill in all fields.';
    } else {
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM users WHERE email = ? AND is_active = 1");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['full_name'];
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['branch_id'] = $user['branch_id'];
            $_SESSION['department_id'] = $user['department_id'];

            setFlashMessage('success', 'Welcome back, ' . $user['full_name'] . '!');

            if ($user['role'] === 'admin') redirect('/admin/dashboard.php');
            elseif ($user['role'] === 'branch_manager') redirect('/manager/dashboard.php');
            elseif ($user['role'] === 'staff') redirect('/staff/dashboard.php');
            else redirect('/customer/dashboard.php');
        } else {
            $error = 'Invalid email or password.';
        }
    }
}

$pageTitle = 'Login - Support Center';
require_once __DIR__ . '/../includes/header.php';
?>

<div class="min-h-[70vh] flex items-center justify-center">
    <div class="bg-white rounded-2xl shadow-xl p-8 w-full max-w-md">
        <div class="text-center mb-8">
            <div class="w-16 h-16 gradient-bg rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-user-lock text-white text-2xl"></i>
            </div>
            <h1 class="text-2xl font-bold text-gray-800">Welcome Back</h1>
            <p class="text-gray-500 mt-2">Sign in to your account</p>
        </div>

        <?php if ($error): ?>
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded-r-lg mb-6">
            <p><i class="fas fa-exclamation-circle mr-2"></i><?= sanitize($error) ?></p>
        </div>
        <?php endif; ?>

        <form method="POST" class="space-y-6">
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                <div class="relative">
                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
                        <i class="fas fa-envelope"></i>
                    </span>
                    <input type="email" id="email" name="email" required
                        class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition"
                        placeholder="you@example.com"
                        value="<?= sanitize($_POST['email'] ?? '') ?>">
                </div>
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                <div class="relative">
                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
                        <i class="fas fa-lock"></i>
                    </span>
                    <input type="password" id="password" name="password" required
                        class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition"
                        placeholder="••••••••">
                </div>
            </div>

            <div class="flex items-center justify-between">
                <label class="flex items-center">
                    <input type="checkbox" class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary">
                    <span class="ml-2 text-sm text-gray-600">Remember me</span>
                </label>
                <a href="#" class="text-sm text-primary hover:underline">Forgot password?</a>
            </div>

            <button type="submit" class="w-full gradient-bg text-white py-3 rounded-lg font-semibold hover:opacity-90 transition transform hover:scale-[1.02]">
                <i class="fas fa-sign-in-alt mr-2"></i>Sign In
            </button>
        </form>

        <div class="mt-6 text-center">
            <p class="text-gray-600">
                Don't have an account? 
                <a href="<?= BASE_URL ?>/auth/register.php" class="text-primary font-semibold hover:underline">Register</a>
            </p>
        </div>

        <div class="mt-8 pt-6 border-t border-gray-200">
            <p class="text-center text-sm text-gray-500 mb-4">Demo Accounts</p>
            <div class="grid grid-cols-1 gap-2 text-xs text-gray-500">
                <div class="bg-gray-50 p-2 rounded"><strong>Admin:</strong> admin@company.com</div>
                <div class="bg-gray-50 p-2 rounded"><strong>Customer:</strong> john@example.com</div>
                <div class="bg-gray-50 p-2 rounded"><strong>Password:</strong> password (for all)</div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
