<?php
require_once __DIR__ . '/../config/config.php';

if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('error', 'Access denied.');
    redirect('/auth/login.php');
}

$db = getDB();

// Get all complaints for export
$complaints = $db->query("
    SELECT c.ticket_number, c.additional_details, c.priority, c.status, c.created_at, c.updated_at,
           o.order_number, o.order_date, o.total_amount,
           u.whatsapp_number as customer_whatsapp, u.email as customer_email,
           i.title as issue_title,
           b.name as branch_name,
           d.name as department_name,
           assigned.full_name as assigned_to_name
    FROM complaints c
    JOIN orders o ON c.order_id = o.id
    JOIN users u ON c.customer_id = u.id
    JOIN branches b ON c.branch_id = b.id
    LEFT JOIN complaint_issues i ON c.issue_id = i.id
    LEFT JOIN departments d ON c.department_id = d.id
    LEFT JOIN users assigned ON c.assigned_to = assigned.id
    ORDER BY c.created_at DESC
")->fetchAll();

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="complaints_export_' . date('Y-m-d') . '.csv"');

$output = fopen('php://output', 'w');

// CSV headers
fputcsv($output, [
    'Ticket Number',
    'Issue',
    'Additional Details',
    'Priority',
    'Status',
    'Branch',
    'Order Number',
    'Order Date',
    'Order Amount',
    'Customer WhatsApp',
    'Customer Email',
    'Department',
    'Assigned To',
    'Created At',
    'Updated At'
]);

// CSV data
foreach ($complaints as $c) {
    fputcsv($output, [
        $c['ticket_number'],
        $c['issue_title'] ?? 'N/A',
        $c['additional_details'] ?? '',
        $c['priority'],
        $c['status'],
        $c['branch_name'],
        $c['order_number'],
        $c['order_date'],
        $c['total_amount'],
        $c['customer_whatsapp'],
        $c['customer_email'] ?? '',
        $c['department_name'] ?? 'N/A',
        $c['assigned_to_name'] ?? 'Unassigned',
        $c['created_at'],
        $c['updated_at']
    ]);
}

fclose($output);
exit;
